<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\Model;

class DynamicPricing extends Model 
{

    protected $table = 'dynamic_pricing';
    public $timestamps = true;
    protected $fillable = array('price_per_product', 'discount_percentage', 'member_only', 'category_id', 'product_id', 'required_quantity', 'priority');

    public function presetCategory()
    {
        return $this->belongsTo('PresetCategory');
    }

    public function preset()
    {
        return $this->belongsTo('Preset');
    }

}