<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Preset extends Model 
{

    protected $table = 'presets';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'price', 'launch_date', 'member_only');

    public function commissions()
    {
        return $this->hasMany('Commission');
    }

    public function orders()
    {
        return $this->hasMany('Order');
    }

    public function categories()
    {
        return $this->belongsToMany('PresetCategory');
    }

    public function tags()
    {
        return $this->morphToMany('Tag');
    }

}