<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalePeriod extends Model 
{

    protected $table = 'sale_periods';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('begins_at', 'expires_at', 'discount_amount', 'discount_percentage', 'category_id', 'product_id', 'product_type', 'product_partner_id', 'coupon_code', 'minimum_spend', 'max_spend', 'excluded_users', 'excluded_categories', 'excluded_products', 'max_uses');

    public function orderedItems()
    {
        return $this->hasMany('OrderItem');
    }

    public function preset()
    {
        return $this->belongsTo('Preset');
    }

    public function category()
    {
        return $this->belongsTo('PresetCategory');
    }

}