<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('username', 255)->unique();
			$table->string('password', 32)->nullable();
			$table->integer('employee_id')->unsigned();
			$table->tinyInteger('active')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}