<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Type extends Model 
{

    protected $table = 'types';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function posts()
    {
        return $this->hasMany('Post');
    }

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function types()
    {
        return $this->belongsToMany('Site_type');
    }

}