<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSitesTable extends Migration {

	public function up()
	{
		Schema::create('sites', function(Blueprint $table) {
			$table->increments('id');
			$table->softDeletes();
			$table->string('name');
			$table->string('slug', 10)->unique();
			$table->string('hex_color', 6);
			$table->string('url');
			$table->string('logo');
			$table->string('type');
			$table->string('trust');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('sites');
	}
}