<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVariantesTable extends Migration {

	public function up()
	{
		Schema::create('variantes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_producto');
			$table->string('ean', 25);
			$table->tinyInteger('orden');
			$table->string('referencia', 100);
			$table->decimal('pvp');
			$table->decimal('pvc');
			$table->string('imagen');
			$table->tinyInteger('home');
			$table->tinyInteger('outlet');
			$table->integer('stock');
			$table->date('fecha_proximo_stock');
			$table->timestamps();
			$table->softDeletes();
			$table->tinyInteger('shopping');
		});
	}

	public function down()
	{
		Schema::drop('variantes');
	}
}