<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 100);
			$table->enum('Subjects', array('Quran', 'Hadith', 'Tawhid'));
			$table->string('author', 100);
			$table->string('reviewer', 100);
			$table->binary('cover');
			$table->binary('textbook');
			$table->string('notes', 100);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}