<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfficesTable extends Migration {

	public function up()
	{
		Schema::create('offices', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50);
			$table->string('address', 200);
			$table->integer('registrationID');
			$table->integer('phone');
			$table->integer('mobile');
			$table->integer('fax');
			$table->binary('logo');
			$table->float('lat');
			$table->float('lan');
			$table->timestamps();
			$table->enum('type', array('office', 'academy'));
		});
	}

	public function down()
	{
		Schema::drop('offices');
	}
}