<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('UUID', 'title_fr', 'title_en', 'description_fr', 'description_en', 'content_fr', 'content_en', 'photo_path', 'banner_photo_path');

	public function categories()
	{
		return $this->belongsToMany('CategoryPost', 'post_id');
	}

	public function sites()
	{
		return $this->belongsToMany('PostSite', 'post_id');
	}

}