<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Discounts extends Eloquent {

	protected $table = 'discounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('code', 'name', 'is_percent', 'amount', 'clinic_id', 'doctor_id', 'uses', 'max_uses', 'start_at', 'expire_at', 'user_id');

	public function clinic()
	{
		return $this->belongsTo('Clinics', 'clinic_id');
	}

	public function doctor()
	{
		return $this->belongsTo('Doctors', 'doctor_id');
	}

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

}