<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_en')->nullable();
			$table->string('name_ar')->nullable();
			$table->text('logo')->nullable();
			$table->integer('clinic_id');
			$table->string('brief')->nullable();
			$table->string('nationality')->nullable();
			$table->decimal('fees')->default('0');
			$table->string('email')->nullable();
			$table->integer('rating')->nullable()->default('0');
			$table->string('phone')->nullable();
			$table->integer('waiting_time')->default('0');
			$table->integer('degree_id');
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}