<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIdentitiesTable extends Migration {

	public function up()
	{
		Schema::create('identities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('auth0_id')->index();
			$table->integer('database_id')->unsigned();
			$table->integer('entity_id')->default('0');
			$table->char('role_id', 2)->default('PD');
			$table->string('description');
			$table->string('status')->default('init');
			$table->boolean('trial');
			$table->json('info')->nullable();
			$table->string('env')->default(''dev'');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('identities');
	}
}