<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Courses extends Eloquent {

	protected $table = 'courses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function enrollment()
	{
		return $this->hasOne('Enrollment');
	}

	public function categort()
	{
		return $this->belongsTo('Category');
	}

	public function payment()
	{
		return $this->hasMany('Payment');
	}

	public function teacher()
	{
		return $this->belongsTo('Teacher');
	}

}