<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Users extends Eloquent {

	protected $table = 'user';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function enrollment()
	{
		return $this->hasMany('Enrollment');
	}

	public function payment()
	{
		return $this->hasMany('Payment');
	}

	public function comments()
	{
		return $this->hasMany('Comment');
	}

}