<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInspectorProfilesTable extends Migration {

	public function up()
	{
		Schema::create('inspector_profiles', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unique()->unsigned();
			$table->integer('zone_id')->unique()->unsigned();
			$table->integer('max_daily_visits')->default('4');
			$table->date('created_at');
			$table->date('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('inspector_profiles');
	}
}