<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function person()
	{
		return $this->belongsTo('App\Models\Person');
	}

	public function subscriptions()
	{
		return $this->hasMany('App\Models\Subscription');
	}

}