<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePostsTable extends Migration {

	public function up()
	{
		Schema::create('posts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('sender');
			$table->string('receiver');
			$table->string('recipient');
			$table->string('title_order');
			$table->string('document');
			$table->integer('price')->default('0');
			$table->string('howpay');
			$table->string('task');
			$table->string('speed');
			$table->datetime('date');
			$table->timestamps();
			$table->integer('city_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('posts');
	}
}