<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('project_sources', function(Blueprint $table) {
			$table->foreign('channel_source_id')->references('id')->on('channel_sources')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('project_sources', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('deals', function(Blueprint $table) {
			$table->foreign('channel_source_id')->references('id')->on('channel_sources')
						->onDelete('set null')
						->onUpdate('no action');
		});
		Schema::table('deals', function(Blueprint $table) {
			$table->foreign('project_source_id')->references('id')->on('projects')
						->onDelete('set null')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('project_sources', function(Blueprint $table) {
			$table->dropForeign('project_sources_channel_source_id_foreign');
		});
		Schema::table('project_sources', function(Blueprint $table) {
			$table->dropForeign('project_sources_project_id_foreign');
		});
		Schema::table('deals', function(Blueprint $table) {
			$table->dropForeign('deals_channel_source_id_foreign');
		});
		Schema::table('deals', function(Blueprint $table) {
			$table->dropForeign('deals_project_source_id_foreign');
		});
	}
}