<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEstateMansionsTable extends Migration {

	public function up()
	{
		Schema::create('estate_mansions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('estate_id')->unsigned();
			$table->integer('total');
			$table->integer('total_sold');
			$table->string('sold_building_no');
			$table->smallInteger('sold_building_floor');
			$table->integer('possession_area_type_id');
			$table->integer('lighting_direction_id');
			$table->date('rent_period');
			$table->decimal('balcony_area');
			$table->decimal('roof_balcony_area');
			$table->decimal('roof_balcony_fee');
			$table->integer('roof_balcony_fee_unit');
			$table->string('terrace_area');
			$table->decimal('terrace_fee');
			$table->string('terrace_fee_unitgarden_area');
			$table->string('garden_fee');
			$table->string('garden_fee_unit');
			$table->date('built_at');
			$table->integer('completion_status_id');
			$table->integer('room_status_id');
			$table->string('total_basement');
			$table->string('mansion_parking_lot_id');
			$table->string('parking_site');
			$table->date('parking_confirmed_at');
			$table->integer('parking_empty_spaces');
			$table->decimal('parking_fee_from');
			$table->integer('parking_fee_to');
			$table->string('parking_fee_unit');
			$table->integer('is_price_including_parking_fee');
			$table->string('is_parking_free');
			$table->integer('construction_company_id');
			$table->string('responsibility_company_id');
			$table->string('management_method_id');
			$table->string('manager_status_id');
			$table->string('is_management_group');
			$table->string('management_fee');
			$table->string('repair_reserve_fee');
			$table->string('repair_reserve_base_fee');
			$table->string('other_fee');
			$table->string('other_fee_name');
			$table->string('interior_reform_status_id');
			$table->string('interior_reformed_at');
			$table->string('exterior_reform_status_id');
			$table->string('exterior_reformed_at');
			$table->string('renovation_status_id');
			$table->string('renovated_at');
			$table->text('restriction');
			$table->string('deleted_at');
			$table->string('exterior_reformed_items');
			$table->string('interior_reform_item_idsinterior_reform_item_ids');
			$table->string('renovation_items');
		});
	}

	public function down()
	{
		Schema::drop('estate_mansions');
	}
}