<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEstateImagesTable extends Migration {

	public function up()
	{
		Schema::create('estate_images', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->string('image_url');
			$table->date('shooted_at');
			$table->string('distance');
			$table->integer('image_type_id');
			$table->integer('estate_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('estate_images');
	}
}