<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Question extends Model 
{

    protected $table = 'questions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function questionType()
    {
        return $this->hasOne('QuizType');
    }

    public function questionChoices()
    {
        return $this->hasMany('QuestionChoices');
    }

    public function questionTableVariables()
    {
        return $this->hasMany('QuestionTalbleVariables');
    }

}