<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePhotographersTable extends Migration {

	public function up()
	{
		Schema::create('photographers', function(Blueprint $table) {
			$table->bigIncrements('id', true);
			$table->bigInteger('seller_id')->unsigned();
			$table->string('name', 65);
			$table->decimal('lat', 6,9);
			$table->decimal('long', 6,9);
			$table->string('phone', 15);
			$table->timestampsTz('open_at');
			$table->timestampsTz('close_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('photographers');
	}
}