<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClicksTable extends Migration {

	public function up()
	{
		Schema::create('clicks', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('position_id');
			$table->string('uuid');
			$table->timestamp('created_at');
			$table->integer('ad_group_id');
			$table->integer('ad_id');
			$table->string('country');
			$table->string('browser');
			$table->string('language');
			$table->string('operating_system');
			$table->string('domain');
			$table->string('protocol');
			$table->integer('is_human');
			$table->string('ad_type');
			$table->string('ip_v4');
			$table->float('cost');
		});
	}

	public function down()
	{
		Schema::drop('clicks');
	}
}