<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePositionCostsTable extends Migration {

	public function up()
	{
		Schema::create('position_costs', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('position_id')->unsigned();
			$table->float('per_cost');
			$table->enum('currency', array('RIAL', 'DOLLOR'));
			$table->enum('type', array('PER_VIEW', 'PER_CLICK'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('position_costs');
	}
}