<?php

namespace App;

class Player extends Eloquent {

	protected $table = 'players';
	public $timestamps = true;

	public function fights()
	{
		return $this->hasMany('Player', 'player_id', 'enemy_id');
	}

	public function items()
	{
		return $this->hasMany('Item');
	}

	public function attributes()
	{
		return $this->hasMany('Attribute');
	}

	public function class()
	{
		return $this->hasMany('Class');
	}

	public function abilities()
	{
		return $this->hasMany('Ability');
	}

}