<?php

namespace App\Models;

class Property extends Eloquent {

	protected $table = 'lim_properties';
	public $timestamps = true;
	protected $fillable = array('table_type', 'table_id', 'lim_property_group_id', 'rank', 'icon');
	protected $visible = array('table_type', 'table_id', 'lim_property_group_id', 'rank', 'icon');

	public function table()
	{
		return $this->morphTo();
	}

	public function languages()
	{
		return $this->hasMany('App\Models\PropertyLanguage', 'lim_property_id');
	}

	public function language()
	{
		return $this->hasOne('App\Models\PropertyLanguage', 'lim_property_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function group()
	{
		return $this->belongsTo('App\Model\PropertyGroup', 'lim_property_group_id');
	}

}