<?php

namespace App\Model;

class PropertyTemplate extends Eloquent {

	protected $table = 'lim_property_templates';
	public $timestamps = true;
	protected $fillable = array('template_file_path');
	protected $visible = array('template_file_path');

	public function language()
	{
		return $this->hasOne('App\Model\PropertyTemplateLanguage', 'lim_property_template_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function languages()
	{
		return $this->hasMany('App\Model\PropertyTemplateLanguage', 'lim_property_template_id');
	}

	public function groups()
	{
		return $this->hasMany('App\Model\PropertyGroup', 'lim_property_template_id');
	}

}