<?php

namespace App\Models;

class Widget extends Eloquent {

	protected $table = 'lim_widgets';
	public $timestamps = true;
	protected $fillable = array('type', 'settings');
	protected $visible = array('type', 'settings');

	public function language()
	{
		return $this->hasOne('App\Models\WidgetLanguage', 'lim_widget_id')->where('lim_language_id', \Config::get('app.language_id'));
	}

	public function contents()
	{
		return $this->morphedByMany('App\Models\Content', 'lim_widget_relation');
	}

	public function categories()
	{
		return $this->morphedByMany('App\Models\Category', 'lim_widget_relation');
	}

	public function languages()
	{
		return $this->hasMany('App\Models\WidgetLanguage', 'lim_widget_id');
	}

}