<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('lim_setting_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_setting_languages', function(Blueprint $table) {
			$table->foreign('lim_setting_id')->references('id')->on('lim_settings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_content_type_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_content_type_languages', function(Blueprint $table) {
			$table->foreign('lim_content_type_id')->references('id')->on('lim_content_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_contents', function(Blueprint $table) {
			$table->foreign('lim_content_type_id')->references('id')->on('lim_content_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_contents', function(Blueprint $table) {
			$table->foreign('lim_category_id')->references('id')->on('lim_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_contents', function(Blueprint $table) {
			$table->foreign('lim_branch_id')->references('id')->on('lim_branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_content_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_content_languages', function(Blueprint $table) {
			$table->foreign('lim_content_id')->references('id')->on('lim_contents')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_categories', function(Blueprint $table) {
			$table->foreign('lim_content_type_id')->references('id')->on('lim_content_types')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_categories', function(Blueprint $table) {
			$table->foreign('lim_category_id')->references('id')->on('lim_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_category_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_category_languages', function(Blueprint $table) {
			$table->foreign('lim_category_id')->references('id')->on('lim_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_field_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_field_languages', function(Blueprint $table) {
			$table->foreign('lim_field_id')->references('id')->on('lim_fields')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_field_items', function(Blueprint $table) {
			$table->foreign('lim_field_id')->references('id')->on('lim_fields')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_field_item_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_field_item_languages', function(Blueprint $table) {
			$table->foreign('lim_field_item_id')->references('id')->on('lim_field_items')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_widget_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_widget_languages', function(Blueprint $table) {
			$table->foreign('lim_widget_id')->references('id')->on('lim_widgets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_field_values', function(Blueprint $table) {
			$table->foreign('lim_field_id')->references('id')->on('lim_fields')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_field_value_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_field_value_languages', function(Blueprint $table) {
			$table->foreign('lim_field_value_id')->references('id')->on('lim_field_values')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_widget_relations', function(Blueprint $table) {
			$table->foreign('lim_widget_id')->references('id')->on('lim_widgets')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('lim_seo_template_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_seo_template_languages', function(Blueprint $table) {
			$table->foreign('lim_seo_template_id')->references('id')->on('lim_seo_templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_seo_fields', function(Blueprint $table) {
			$table->foreign('lim_seo_template_id')->references('id')->on('lim_seo_templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_seo_field_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_seo_field_languages', function(Blueprint $table) {
			$table->foreign('lim_seo_field_id')->references('id')->on('lim_seo_fields')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_language_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_galleries', function(Blueprint $table) {
			$table->foreign('lim_gallery_template_id')->references('id')->on('lim_gallery_templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_gallery_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_gallery_languages', function(Blueprint $table) {
			$table->foreign('lim_gallery_id')->references('id')->on('lim_galleries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_gallery_template_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_gallery_template_languages', function(Blueprint $table) {
			$table->foreign('lim_gallery_template_id')->references('id')->on('lim_gallery_templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_branches', function(Blueprint $table) {
			$table->foreign('lim_content_type_id')->references('id')->on('lim_content_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_branch_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_branch_languages', function(Blueprint $table) {
			$table->foreign('lim_branch_id')->references('id')->on('lim_branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_image_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_image_languages', function(Blueprint $table) {
			$table->foreign('lim_image_id')->references('id')->on('lim_images')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_properties', function(Blueprint $table) {
			$table->foreign('lim_property_group_id')->references('id')->on('lim_property_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_property_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_property_languages', function(Blueprint $table) {
			$table->foreign('lim_property_id')->references('id')->on('lim_properties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_property_group_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_property_group_languages', function(Blueprint $table) {
			$table->foreign('lim_property_group_id')->references('id')->on('lim_property_groups')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_property_template_languages', function(Blueprint $table) {
			$table->foreign('lim_language_id')->references('id')->on('lim_languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lim_property_template_languages', function(Blueprint $table) {
			$table->foreign('lim_property_template_id')->references('id')->on('lim_property_templates')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('lim_setting_languages', function(Blueprint $table) {
			$table->dropForeign('lim_setting_languages_lim_language_id_foreign');
		});
		Schema::table('lim_setting_languages', function(Blueprint $table) {
			$table->dropForeign('lim_setting_languages_lim_setting_id_foreign');
		});
		Schema::table('lim_content_type_languages', function(Blueprint $table) {
			$table->dropForeign('lim_content_type_languages_lim_language_id_foreign');
		});
		Schema::table('lim_content_type_languages', function(Blueprint $table) {
			$table->dropForeign('lim_content_type_languages_lim_content_type_id_foreign');
		});
		Schema::table('lim_contents', function(Blueprint $table) {
			$table->dropForeign('lim_contents_lim_content_type_id_foreign');
		});
		Schema::table('lim_contents', function(Blueprint $table) {
			$table->dropForeign('lim_contents_lim_category_id_foreign');
		});
		Schema::table('lim_contents', function(Blueprint $table) {
			$table->dropForeign('lim_contents_lim_branch_id_foreign');
		});
		Schema::table('lim_content_languages', function(Blueprint $table) {
			$table->dropForeign('lim_content_languages_lim_language_id_foreign');
		});
		Schema::table('lim_content_languages', function(Blueprint $table) {
			$table->dropForeign('lim_content_languages_lim_content_id_foreign');
		});
		Schema::table('lim_categories', function(Blueprint $table) {
			$table->dropForeign('lim_categories_lim_content_type_id_foreign');
		});
		Schema::table('lim_categories', function(Blueprint $table) {
			$table->dropForeign('lim_categories_lim_category_id_foreign');
		});
		Schema::table('lim_category_languages', function(Blueprint $table) {
			$table->dropForeign('lim_category_languages_lim_language_id_foreign');
		});
		Schema::table('lim_category_languages', function(Blueprint $table) {
			$table->dropForeign('lim_category_languages_lim_category_id_foreign');
		});
		Schema::table('lim_field_languages', function(Blueprint $table) {
			$table->dropForeign('lim_field_languages_lim_language_id_foreign');
		});
		Schema::table('lim_field_languages', function(Blueprint $table) {
			$table->dropForeign('lim_field_languages_lim_field_id_foreign');
		});
		Schema::table('lim_field_items', function(Blueprint $table) {
			$table->dropForeign('lim_field_items_lim_field_id_foreign');
		});
		Schema::table('lim_field_item_languages', function(Blueprint $table) {
			$table->dropForeign('lim_field_item_languages_lim_language_id_foreign');
		});
		Schema::table('lim_field_item_languages', function(Blueprint $table) {
			$table->dropForeign('lim_field_item_languages_lim_field_item_id_foreign');
		});
		Schema::table('lim_widget_languages', function(Blueprint $table) {
			$table->dropForeign('lim_widget_languages_lim_language_id_foreign');
		});
		Schema::table('lim_widget_languages', function(Blueprint $table) {
			$table->dropForeign('lim_widget_languages_lim_widget_id_foreign');
		});
		Schema::table('lim_field_values', function(Blueprint $table) {
			$table->dropForeign('lim_field_values_lim_field_id_foreign');
		});
		Schema::table('lim_field_value_languages', function(Blueprint $table) {
			$table->dropForeign('lim_field_value_languages_lim_language_id_foreign');
		});
		Schema::table('lim_field_value_languages', function(Blueprint $table) {
			$table->dropForeign('lim_field_value_languages_lim_field_value_id_foreign');
		});
		Schema::table('lim_widget_relations', function(Blueprint $table) {
			$table->dropForeign('lim_widget_relations_lim_widget_id_foreign');
		});
		Schema::table('lim_seo_template_languages', function(Blueprint $table) {
			$table->dropForeign('lim_seo_template_languages_lim_language_id_foreign');
		});
		Schema::table('lim_seo_template_languages', function(Blueprint $table) {
			$table->dropForeign('lim_seo_template_languages_lim_seo_template_id_foreign');
		});
		Schema::table('lim_seo_fields', function(Blueprint $table) {
			$table->dropForeign('lim_seo_fields_lim_seo_template_id_foreign');
		});
		Schema::table('lim_seo_field_languages', function(Blueprint $table) {
			$table->dropForeign('lim_seo_field_languages_lim_language_id_foreign');
		});
		Schema::table('lim_seo_field_languages', function(Blueprint $table) {
			$table->dropForeign('lim_seo_field_languages_lim_seo_field_id_foreign');
		});
		Schema::table('lim_language_languages', function(Blueprint $table) {
			$table->dropForeign('lim_language_languages_lim_language_id_foreign');
		});
		Schema::table('lim_galleries', function(Blueprint $table) {
			$table->dropForeign('lim_galleries_lim_gallery_template_id_foreign');
		});
		Schema::table('lim_gallery_languages', function(Blueprint $table) {
			$table->dropForeign('lim_gallery_languages_lim_language_id_foreign');
		});
		Schema::table('lim_gallery_languages', function(Blueprint $table) {
			$table->dropForeign('lim_gallery_languages_lim_gallery_id_foreign');
		});
		Schema::table('lim_gallery_template_languages', function(Blueprint $table) {
			$table->dropForeign('lim_gallery_template_languages_lim_language_id_foreign');
		});
		Schema::table('lim_gallery_template_languages', function(Blueprint $table) {
			$table->dropForeign('lim_gallery_template_languages_lim_gallery_template_id_foreign');
		});
		Schema::table('lim_branches', function(Blueprint $table) {
			$table->dropForeign('lim_branches_lim_content_type_id_foreign');
		});
		Schema::table('lim_branch_languages', function(Blueprint $table) {
			$table->dropForeign('lim_branch_languages_lim_language_id_foreign');
		});
		Schema::table('lim_branch_languages', function(Blueprint $table) {
			$table->dropForeign('lim_branch_languages_lim_branch_id_foreign');
		});
		Schema::table('lim_image_languages', function(Blueprint $table) {
			$table->dropForeign('lim_image_languages_lim_language_id_foreign');
		});
		Schema::table('lim_image_languages', function(Blueprint $table) {
			$table->dropForeign('lim_image_languages_lim_image_id_foreign');
		});
		Schema::table('lim_properties', function(Blueprint $table) {
			$table->dropForeign('lim_properties_lim_property_group_id_foreign');
		});
		Schema::table('lim_property_languages', function(Blueprint $table) {
			$table->dropForeign('lim_property_languages_lim_language_id_foreign');
		});
		Schema::table('lim_property_languages', function(Blueprint $table) {
			$table->dropForeign('lim_property_languages_lim_property_id_foreign');
		});
		Schema::table('lim_property_group_languages', function(Blueprint $table) {
			$table->dropForeign('lim_property_group_languages_lim_language_id_foreign');
		});
		Schema::table('lim_property_group_languages', function(Blueprint $table) {
			$table->dropForeign('lim_property_group_languages_lim_property_group_id_foreign');
		});
		Schema::table('lim_property_template_languages', function(Blueprint $table) {
			$table->dropForeign('lim_property_template_languages_lim_language_id_foreign');
		});
		Schema::table('lim_property_template_languages', function(Blueprint $table) {
			$table->dropForeign('lim_property_template_languages_lim_property_template_id_foreign');
		});
	}
}