<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Cadeau extends Eloquent {

	protected $table = 'cadeaux';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('invite_id', 'slug', 'key_pay_api', 'montant', 'received_amount', 'nom', 'devise', 'methode', 'statut');
	protected $visible = array('invite_id', 'slug', 'key_pay_api', 'montant', 'received_amount', 'nom', 'devise', 'methode', 'statut');

	public function invite()
	{
		return $this->belongsTo('App\Models\Invite', 'invite_id');
	}

}