<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CategoriePhoto extends Eloquent {

	protected $table = 'categories_photos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'categorie_id', 'photo_id');
	protected $visible = array('slug', 'categorie_id', 'photo_id');

	public function categorie()
	{
		return $this->belongsTo('App\Models\Categorie', 'categorie_id');
	}

	public function photo()
	{
		return $this->belongsTo('App\Models\Photo', 'photo_id');
	}

}