<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Photo extends Eloquent {

	protected $table = 'photos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('slug', 'evenement_id', 'nom', 'statut');
	protected $visible = array('slug', 'evenement_id', 'nom', 'statut');

	public function categoriePhoto()
	{
		return $this->hasMany('App\Models\CategoriePhoto', 'photo_id');
	}

	public function positionPhoto()
	{
		return $this->hasMany('App\Models\PositionPhoto', 'photo_id');
	}

	public function evenement()
	{
		return $this->belongsTo('App\Models\Evenement', 'evenement_id');
	}

}