<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ReponseQuestion extends Eloquent {

	protected $table = 'reponses_questions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('question_id', 'slug', 'etat', 'libelle', 'statut');
	protected $visible = array('question_id', 'slug', 'etat', 'libelle', 'statut');

	public function question()
	{
		return $this->belongsTo('App\Models\Question', 'question_id');
	}

	public function inviteReponseQuestion()
	{
		return $this->hasMany('App\Models\InviteReponseQuestion', 'reponse_question_id');
	}

}