<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSectionTable extends Migration {

	public function up()
	{
		Schema::create('section', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->tinyInteger('level')->unsigned()->index()->default('0');
			$table->bigInteger('parent')->unsigned()->index();
			$table->tinyInteger('sort')->unsigned()->default('0');
			$table->tinyInteger('country_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('section');
	}
}