<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class NewsShares extends Model 
{

    protected $table = 'news_shares';
    public $timestamps = true;
    protected $fillable = array('news_id', 'posted_by', 'shared_by');
    protected $visible = array('news_id', 'posted_by', 'shared_by');

    public function news()
    {
        return $this->belongsTo('App\News', 'news_id');
    }

    public function postedBy()
    {
        return $this->belongsTo('App\User', 'posted_by');
    }

}