<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class PostLike extends Model 
{

    protected $table = 'posts_like';
    public $timestamps = true;
    protected $fillable = array('post_id', 'posted_by', 'liked_by');
    protected $visible = array('post_id', 'posted_by', 'liked_by');

    public function post()
    {
        return $this->belongsTo('App\Posts', 'post_id');
    }

    public function postedBy()
    {
        return $this->belongsTo('App\User', 'posted_by');
    }

    public function likeBy()
    {
        return $this->belongsTo('App\User', 'liked_by');
    }

}