<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRelationshipTable extends Migration {

	public function up()
	{
		Schema::create('relationship', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_one_id')->unsigned();
			$table->bigInteger('user_to_id')->unsigned();
			$table->timestamps();
			$table->enum('status', array('Pending', 'Accepted', 'Declined', 'Blocked'));
			$table->bigInteger('action_user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('relationship');
	}
}