<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('posted_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('shared_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_like', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_like', function(Blueprint $table) {
			$table->foreign('posted_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_like', function(Blueprint $table) {
			$table->foreign('liked_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_comments', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_comments', function(Blueprint $table) {
			$table->foreign('posted_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_comments', function(Blueprint $table) {
			$table->foreign('commented_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_shares', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_shares', function(Blueprint $table) {
			$table->foreign('posted_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('posts_shares', function(Blueprint $table) {
			$table->foreign('shared_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('posted_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('shared_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->foreign('posted_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('relationship', function(Blueprint $table) {
			$table->foreign('user_one_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('relationship', function(Blueprint $table) {
			$table->foreign('user_to_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('relationship', function(Blueprint $table) {
			$table->foreign('action_user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('news_shares', function(Blueprint $table) {
			$table->foreign('news_id')->references('id')->on('news')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('news_shares', function(Blueprint $table) {
			$table->foreign('posted_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('news_shares', function(Blueprint $table) {
			$table->foreign('shared_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_posted_by_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_shared_by_foreign');
		});
		Schema::table('posts_like', function(Blueprint $table) {
			$table->dropForeign('posts_like_post_id_foreign');
		});
		Schema::table('posts_like', function(Blueprint $table) {
			$table->dropForeign('posts_like_posted_by_foreign');
		});
		Schema::table('posts_like', function(Blueprint $table) {
			$table->dropForeign('posts_like_liked_by_foreign');
		});
		Schema::table('posts_comments', function(Blueprint $table) {
			$table->dropForeign('posts_comments_post_id_foreign');
		});
		Schema::table('posts_comments', function(Blueprint $table) {
			$table->dropForeign('posts_comments_posted_by_foreign');
		});
		Schema::table('posts_comments', function(Blueprint $table) {
			$table->dropForeign('posts_comments_commented_by_foreign');
		});
		Schema::table('posts_shares', function(Blueprint $table) {
			$table->dropForeign('posts_shares_post_id_foreign');
		});
		Schema::table('posts_shares', function(Blueprint $table) {
			$table->dropForeign('posts_shares_posted_by_foreign');
		});
		Schema::table('posts_shares', function(Blueprint $table) {
			$table->dropForeign('posts_shares_shared_by_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_posted_by_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_shared_by_foreign');
		});
		Schema::table('events', function(Blueprint $table) {
			$table->dropForeign('events_posted_by_foreign');
		});
		Schema::table('relationship', function(Blueprint $table) {
			$table->dropForeign('relationship_user_one_id_foreign');
		});
		Schema::table('relationship', function(Blueprint $table) {
			$table->dropForeign('relationship_user_to_id_foreign');
		});
		Schema::table('relationship', function(Blueprint $table) {
			$table->dropForeign('relationship_action_user_id_foreign');
		});
		Schema::table('news_shares', function(Blueprint $table) {
			$table->dropForeign('news_shares_news_id_foreign');
		});
		Schema::table('news_shares', function(Blueprint $table) {
			$table->dropForeign('news_shares_posted_by_foreign');
		});
		Schema::table('news_shares', function(Blueprint $table) {
			$table->dropForeign('news_shares_shared_by_foreign');
		});
	}
}