<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdrecAssetSpecTable extends Migration {

	public function up()
	{
		Schema::create('adrec_asset_spec', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->index();
			$table->json('assettype')->nullable();
			$table->json('spec')->nullable();
			$table->string('preview', 500)->nullable();
			$table->json('creator')->nullable();
			$table->string('package')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('adrec_asset_spec');
	}
}