<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Restaurant extends Model 
{

    protected $table = 'restaurants';
    public $timestamps = true;

    public function district()
    {
        return $this->hasOne('District');
    }

    public function cuisines()
    {
        return $this->hasMany('Category');
    }

    public function reviewers()
    {
        return $this->belongsToMany('Customer');
    }

    public function promotions()
    {
        return $this->hasMany('Offer');
    }

}