<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrainingsTable extends Migration {

	public function up()
	{
		Schema::create('trainings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 199);
			$table->string('thumbnail', 255);
			$table->string('preview', 255);
			$table->text('description');
			$table->string('location', 255);
			$table->integer('overall_rating')->default('0');
			$table->integer('price')->default('0');
			$table->boolean('is_online');
			$table->integer('creator_id');
		});
	}

	public function down()
	{
		Schema::drop('trainings');
	}
}