<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientTable extends Migration {

	public function up()
	{
		Schema::create('client', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->text('name')->nullable();
			$table->string('mobile')->nullable();
			$table->string('whatsapp')->nullable();
			$table->string('mark')->nullable();
			$table->string('account_number')->nullable();
			$table->string('email')->nullable();
			$table->string('company')->nullable();
			$table->double('balance_aed')->default('0');
			$table->double('balance_mru')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('client');
	}
}