<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContainerTable extends Migration {

	public function up()
	{
		Schema::create('container', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('container_number')->nullable();
			$table->boolean('is_fcl')->default(0);
			$table->integer('client_id')->nullable();
			$table->integer('transporting_company_id')->nullable();
			$table->integer('from_harbor_id')->nullable();
			$table->integer('to_harbor_id')->nullable();
			$table->double('total_cost')->default('0');
			$table->enum('status', array('pending', 'on_way', 'arrived'))->nullable();
			$table->date('shipping_date')->nullable();
			$table->date('arrival_date')->nullable();
			$table->double('collected_fund')->default('0');
			$table->double('shipping_yard')->nullable()->default('0');
			$table->double('labor')->default('0');
			$table->double('tax')->default('0');
			$table->double('other_fees')->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('container');
	}
}