<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoiceTable extends Migration {

	public function up()
	{
		Schema::create('invoice', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id')->nullable();
			$table->date('date');
			$table->double('total')->default('0');
			$table->integer('account_id');
		});
	}

	public function down()
	{
		Schema::drop('invoice');
	}
}