<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShipmentItemTable extends Migration {

	public function up()
	{
		Schema::create('shipment_item', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('shipment_id')->nullable();
			$table->double('width')->nullable()->default('0');
			$table->double('height')->nullable()->default('0');
			$table->integer('quantity')->nullable()->default('1');
			$table->double('price')->nullable()->default('0');
			$table->double('area')->nullable();
			$table->string('type')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('shipment_item');
	}
}