<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Products extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'image', 'media', 'price', 'short_text', 'description', 'download');

	public function category()
	{
		return $this->belongsTo('Categories');
	}

}