<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Organisation extends Model 
{

    protected $table = 'organisations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function userDetail()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function categoryDetail()
    {
        return $this->hasOne('Category', 'category');
    }

}