<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Professionals extends Eloquent {

	protected $table = 'professionals';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function userDetail()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function experiance()
	{
		return $this->hasMany('Experience', 'pro_id');
	}

	public function categoryDetail()
	{
		return $this->hasOne('Category', 'cat_id');
	}

}