<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDestinationsTable extends Migration {

	public function up()
	{
		Schema::create('destinations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->float('location_lat');
			$table->float('location_long');
			$table->integer('passenger_id')->unsigned();
			$table->string('name');
		});
	}

	public function down()
	{
		Schema::drop('destinations');
	}
}